import _ from 'lodash';

import { TableItemProps } from '../TableItem';
import EmptyItem from './EmptyItem';

//HEX Цвета рейтинга от красного к зеленому без других оттенков где 0 - это красный, 5 - зеленый
// 0 - 5
const rateColor = [
    "#ff0000", // 0
    "#cc4100", // 1
    "#cc4100", // 2
    "#cc7e00", // 3
    "#6d9c02", // 4
    "#00a616", // 4
]

const RateItem = (props: TableItemProps) => {



    const value = props.value;

    if (value == undefined || value == null || !value) return <EmptyItem {...props} />;






    return <div className="text-center font-medium " style={{ color: rateColor[Math.round(value)] }}>{_.isNumber(value) ? (+value).toLocaleString() : ""}</div>

}

export default RateItem;