import dayjs from 'dayjs';
import _ from 'lodash';

import { TableItemProps } from '../TableItem';
import EmptyItem from './EmptyItem';

const UnixDateTimeItem = (props: TableItemProps) => {

    const value = props.value;


    if (!value) return <EmptyItem {...props} />;




    return <div>
        <div>{dayjs.unix(value).format("DD.MM.YYYY")}</div>
        <div className='text-xs'>{dayjs.unix(value).format("HH:mm")}</div>
    </div>


}

export default UnixDateTimeItem;