import React from 'react';

import { useAppConfig } from '@/contexts/AppConfigContext';

import CollectionTable, {
    CollectionTableProps,
} from '../CollectionTable/CollectionTable';
import {
    Dialog,
    DialogContent,
} from '../ui/dialog';
import {
    Grid,
    GridCol,
} from '../ui/grid';
import {
    MobilePage,
    MobilePopup,
} from '../ui/mobile';

const CollectionTableView = (props: CollectionTableProps) => {

    const { isMobile, closeDialog } = useAppConfig();


    const onClose = () => {
        closeDialog(props.modalKey);
    }

    if (isMobile) {
        return <MobilePopup opened={true} onBackdropClick={() => { onClose() }}>
            <MobilePage>
                <CollectionTable {...props}
                    dialog={true}
                />
            </MobilePage>
        </MobilePopup>
    }


    return (
        <Dialog open={true} onOpenChange={() => { onClose() }}>
            <DialogContent className="!w-[80vw] !max-w-[80vw] sm:!max-w-[80vw] h-[80vh] overflow-hidden !p-0" >
                <Grid className='w-[80vw] h-[80vh]' >
                    <GridCol>

                        <CollectionTable {...props}
                            dialog={true}
                        />
                    </GridCol>
                </Grid>
            </DialogContent>
        </Dialog>
    );
};

export default CollectionTableView;