import {
    useEffect,
    useState,
} from 'react';

import _ from 'lodash';
import { Loader2Icon } from 'lucide-react';

import { getDisplayValue } from '@/api/displayValuesService';

const DisplayValue = ({ value, collection }: { value: any, collection?: string }) => {





    const [display, setDisplay] = useState<string | null>(null);

    const [loading, setLoading] = useState<boolean>(true);

    useEffect(() => {
        if (collection && value) {
            setLoading(true);

            getDisplayValue(collection, value)
                .then((displayValue) => {
                    setDisplay(displayValue);
                })
                .catch((error) => {
                    console.error('Error fetching display value:', error);
                    setDisplay(null);
                })
                .finally(() => {
                    setLoading(false);
                });
        } else {
            setDisplay(null);
            setLoading(false);
        }
    }, [value, collection]);

    return <span
        className='text-sm font-medium'

    >{display} {loading && <Loader2Icon className="size-4 animate-spin" />}</span>;

}

export default DisplayValue;