import {
    type CSSProperties,
    type ReactNode,
    useEffect,
    useState,
} from 'react';

import { cn } from '@/lib/utils';

const FreeDialog = ({
    open,
    onOpenChange,
    children, className, style }: { open: boolean, onOpenChange: (open: boolean) => void, children: ReactNode, className?: string, style?: CSSProperties }) => {

    const [openState, setOpenState] = useState(false);
    useEffect(() => {
        if (open) {
            setOpenState(true);
            onOpenChange(true);
        } else {
            setOpenState(false);
            onOpenChange(false);
        }
    }, [open]);

    if (!openState) return null;

    return (
        <div
            style={{
                zIndex: 99999,
                // Не пропускаем нажатия ниже (должно быть auto, а не none)
                pointerEvents: 'auto',
            }}

            onClick={() => onOpenChange(false)}
            className="fixed top-0 left-0 w-full h-full z-50 bg-black/50 flex items-center justify-center">
            <div
                onClick={(e) => {
                    e.stopPropagation();
                }}
                style={{ ...style, pointerEvents: 'auto' }}
                className={cn("bg-background  fixed top-[50%] left-[50%] z-50 grid w-full max-w-[calc(100%-2rem)] translate-x-[-50%] translate-y-[-50%] gap-4 rounded-lg border p-6 shadow-lg duration-200 outline-none ", className)}>
                {children}
            </div>
        </div>
    )
}

export default FreeDialog;