import React, {
    forwardRef,
    useImperativeHandle,
    useRef,
    useState,
} from 'react';

import { XIcon } from 'lucide-react';

import {
    MobileLink,
    MobileNavbar,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';

import {
    Dialog,
    DialogContent,
} from '../ui/dialog';
import {
    Grid,
    GridCol,
    GridRow,
} from '../ui/grid';
import IDSelectOneBlock from './components/IDSelectOneBlock';

export const idSearchCommandRef = React.createRef<IDSearchCommandRefProps>();


type OpenParamsType = {
    collection: string;
    onSelect: (item: any) => void;
}

type IDSearchCommandRefProps = {
    open: (params: OpenParamsType) => void;
    close: () => void;
}

export const IDSearchCommand = forwardRef<IDSearchCommandRefProps, {}>((_, ref) => {


    const [open, setOpen] = useState(false);

    const [search, setSearch] = useState<string>('');

    const timeout = useRef<any>(null);

    const [collection, setCollection] = useState<string>('');




    const onSelectRef = useRef<((item: any) => void) | null>(null);
    useImperativeHandle(ref, () => ({
        open: (params: OpenParamsType) => {

            setCollection(params.collection);
            onSelectRef.current = params.onSelect;
            setOpen(true);
        },
        close: () => {
            setOpen(false);
        }
    }));


    const { isMobile } = useAppConfig();

    return <Dialog



        open={open} onOpenChange={setOpen}>



        <DialogContent className="sm:max-w-[500px] sm:h-[80vh]" >

            <Grid
                className=' h-full w-full'
            >
                <GridCol>
                    {isMobile && <GridRow autoSize><MobileNavbar
                        title={""}

                        right={
                            <MobileLink iconOnly onClick={() => setOpen(false)}>
                                <XIcon />
                            </MobileLink>
                        }
                    /></GridRow>}



                    <IDSelectOneBlock collection={collection} onSelect={(id) => {
                        onSelectRef.current?.(id);
                        setOpen(false);
                    }} />
                </GridCol>



            </Grid>




        </DialogContent>
    </Dialog>





    return (
        <Dialog



            open={open} onOpenChange={setOpen}>



            <DialogContent showCloseButton={false}>

                {isMobile && <MobileNavbar
                    title={""}

                    right={
                        <MobileLink iconOnly onClick={() => setOpen(false)}>
                            <XIcon />
                        </MobileLink>
                    }
                />}
                <Grid className='h-full'>




                    <IDSelectOneBlock collection={collection} onSelect={(id) => {
                        onSelectRef.current?.(id);
                        setOpen(false);
                    }} />

                </Grid>

            </DialogContent>

        </Dialog>

    )
});
