import * as React from 'react';

function useEffectDebounce(
  delay: number,
  effect: React.EffectCallback,
  deps?: React.DependencyList
) {
  React.useEffect(() => {
    let cleanup: ReturnType<React.EffectCallback> | undefined;
    const timeoutId = setTimeout(() => {
      cleanup = effect();
    }, delay);

    return () => {
      clearTimeout(timeoutId);
      if (cleanup) {
        cleanup();
      }
    };
  }, deps);
}

export { useEffectDebounce };
