import React from 'react';

import { LuLock } from 'react-icons/lu';

import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import {
    MobileBlock,
    MobileButton,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';

const LoginPasswordInput = ({ password, setPassword, onPasswordAuth, loading, onForgotPassword }: { password: string, setPassword: (password: string) => void, onPasswordAuth: () => void, loading: boolean, onForgotPassword: () => void }) => {

    const { isMobile } = useAppConfig();

    if (isMobile) {
        return <>
            <MobileBlock>
                <Input
                    className="my-2"
                    type="password"
                    icon={<LuLock />}
                    id={'password'}
                    name='password'
                    placeholder={'Пароль'}
                    value={password}
                    security=""
                    onChange={(e) => setPassword(e.target.value)}
                    onKeyPress={(event: any) => {
                        if (event.key === 'Enter') {
                            onPasswordAuth();
                        }
                    }}
                />

                <MobileButton
                    className='mt-2'
                    disabled={!password || loading}
                    onClick={onPasswordAuth}
                >{Lang.key('continue')}</MobileButton>
                <MobileButton
                    outline
                    className='mt-2'
                    disabled={loading}
                    onClick={onForgotPassword}
                >{Lang.key('forgotPassword')}</MobileButton>
            </MobileBlock>
        </>
    }

    return <>



        <Input
            className="my-2"
            type="password"
            icon={<LuLock />}
            id={'password'}
            name='password'
            placeholder={'Пароль'}
            value={password}
            security=""
            onChange={(e) => setPassword(e.target.value)}
            onKeyPress={(event: any) => {
                if (event.key === 'Enter') {
                    onPasswordAuth();
                }
            }}
        />

        <Button
            disabled={!password || loading}

            onClick={onPasswordAuth}
            className='mt-2 w-full'

            variant="default"

        >{Lang.key('continue')}</Button>


        <Button
            disabled={loading}
            className='mt-2 w-full'
            onClick={onForgotPassword}

            variant="link"

        >{Lang.key('forgotPassword')}</Button>




    </>

}

export default LoginPasswordInput;