import CountryPhoneInput from 'react-phone-input-2';

import { Button } from '@/components/ui/button';
import {
    MobileBlock,
    MobileButton,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';

const LoginPhoneInput = ({ phone, setPhone, onPhoneAuth, loading }: { phone: string, setPhone: (phone: string) => void, onPhoneAuth: () => void, loading: boolean }) => {


    const { isMobile } = useAppConfig();

    if (isMobile) {
        return <>
            <MobileBlock>
                <CountryPhoneInput
                    containerClass="!w-full phone-input-field my-8"
                    inputClass="!w-full !h-10 !text-base !text-base  !rounded-md !border-2 !border-gray-400 !p-2"
                    specialLabel={Lang.key('enterPhoneLogin')}
                    placeholder={Lang.key('phone')}
                    value={phone}
                    onChange={(val) => {
                        setPhone(val);
                    }}

                />

                <MobileButton
                    className='mt-2'
                    disabled={!phone || loading}
                    onClick={onPhoneAuth}
                >{Lang.key('continue')}</MobileButton>
            </MobileBlock>
        </>
    }
    return <>

        <CountryPhoneInput
            containerClass="!w-full phone-input-field my-8"
            inputClass="!w-full !h-10 !text-base !text-base  !rounded-md !border-2 !border-gray-400 !p-2"
            specialLabel={Lang.key('enterPhoneLogin')}
            placeholder={Lang.key('phone')}
            value={phone}
            onChange={(val) => {
                setPhone(val);
            }}

        />


        <Button
            disabled={!phone || loading}

            onClick={onPhoneAuth}
            className='mt-2 w-full'


        >{Lang.key('continue')}</Button>

    </>

}

export default LoginPhoneInput;