import {
    FaGoogle,
    FaVk,
    FaYandex,
} from 'react-icons/fa';

import { Button } from '@/components/ui/button';
import {
    MobileBlock,
    MobileButton,
} from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';
import { Lang } from '@/lang/Lang';

import OrLine from './OrLine';

const SocialLoginButtons = ({ onSocAuth }: { onSocAuth: (type: string) => void }) => {
    const { auth, isMobile } = useAppConfig();


    if (!auth?.socialLogin) {
        return null;
    }

    if (isMobile) {
        return <MobileBlock outline> <div className="grid grid-cols-3 gap-2">

            <MobileButton

                outline
                large

                onClick={() => {
                    onSocAuth('vk');
                }}
            >
                <FaVk size={30} className=' text-blue-600' />
            </MobileButton>
            <MobileButton
                outline
                large
                onClick={() => {
                    onSocAuth('ya');
                }}
            >
                <FaYandex size={20} className=' text-red-600' />
            </MobileButton>
            <MobileButton
                outline
                large
                onClick={() => {
                    onSocAuth('google');
                }}
            >
                <FaGoogle size={20} className=' text-gray-600' />
            </MobileButton>
        </div>
        </MobileBlock>
    }


    return <>

        <OrLine />


        <div className="grid grid-cols-3 gap-2">
            <Button
                variant='outline'
                onClick={() => {
                    onSocAuth('vk');
                }}
            >
                <FaVk size={30} className=' text-blue-600' /> {Lang.key('vkLogin')}
            </Button>

            <Button
                variant='outline'
                onClick={() => {
                    onSocAuth('ya');
                }}
            >
                <FaYandex size={20} className=' text-red-600' /> {Lang.key('yaLogin')}
            </Button>

            <Button
                variant='outline'
                onClick={() => {
                    onSocAuth('google');
                }}
            >
                <FaGoogle size={20} className=' text-gray-600' />
                {Lang.key('googleLogin')}
            </Button>
        </div>




    </>
}

export default SocialLoginButtons;