import {
    Grid,
    GridCol,
} from '@/components/ui/grid';
import { MobilePage } from '@/components/ui/mobile';
import { useAppConfig } from '@/contexts/AppConfigContext';

import { AppSidebar } from './components/AppSidebar';
import MainScreenContent from './components/MainScreenContent';
import {
    ProfileDialog,
    profileDialogRef,
} from './components/ProfileDialog/ProfileDialog';
import { MainPageProvider } from './contexts/MainPageContext';

const MainPage = () => {

    const { isMobile } = useAppConfig();


    if (isMobile) {
        return <MainPageProvider>
            <MobilePage>
                <MainScreenContent />
                <AppSidebar />
            </MobilePage>
            <ProfileDialog ref={profileDialogRef} />
        </MainPageProvider>
    }

    return (<MainPageProvider>
        <Grid className='h-screen w-screen'>
            <GridCol width="300px" className='border-r'>
                <AppSidebar />
            </GridCol>
            <GridCol  >
                <MainScreenContent />
            </GridCol>
        </Grid>
        <ProfileDialog ref={profileDialogRef} />

    </MainPageProvider>
    )


}

export default MainPage;