export const EventEmitter = {
  events: {} as Record<string, ((data?: any) => void)[]>,

  execute(event: string, data?: any) {
    if (!this.events[event]) return;
    this.events[event].forEach(callback => callback(data));
  },

  subscribe(event: string, callback: (data?: any) => void): () => void {
    if (!this.events[event]) this.events[event] = [];
    this.events[event].push(callback);

    return () => {
      this.events[event] = this.events[event].filter(cb => cb !== callback);
    };

  },

  delete(event: string) {
    delete this.events[event];
  },
};
