import _ from 'lodash';

import {
  StructureType,
  TypeABCDEFGHILMPRSTUEnum,
} from '@/api/types';
import { toast } from '@/components/ToastRoot';
import { Lang } from '@/lang/Lang';

export const generateUUID = (length: number) => {
  var baseStr = '';
  if (length) {
    for (var i = 0; i < length; i++) baseStr += 'x';
  } else {
    baseStr = 'xxxxxxxxxx';
  }
  var d = new Date().getTime();
  var uuid = baseStr.replace(/[xy]/g, function (c) {
    var r = (d + Math.random() * 16) % 16 | 0;
    d = Math.floor(d / 16);
    return (c == 'x' ? r : (r & 0x3) | 0x8).toString(16);
  });
  return uuid;
};

export const getAlphaNumericRandom = (len: number): string => {
  if (len == undefined || len <= 0) {
    len = 1;
  }
  var characters =
    'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
  var result = '';
  var iffirst = 0;
  for (var i = 0; i < len; i++) {
    if (i == 0) {
      iffirst = 10;
    } else {
      iffirst = 0;
    }
    result +=
      characters[Math.round(Math.random() * (characters.length - iffirst - 1))];
  }
  return result;
};


const fallbackCopyTextToClipboard = (text: string) => {
  var textArea = document.createElement('textarea');
  textArea.value = text;

  // Avoid scrolling to bottom
  textArea.style.top = '0';
  textArea.style.left = '0';
  textArea.style.position = 'fixed';

  document.body.appendChild(textArea);
  textArea.focus();
  textArea.select();

  try {
    var successful = document.execCommand('copy');
    if (successful) {
      toast.success(Lang.key('copiedToClipboard'));
    }
  } catch (err) { }

  document.body.removeChild(textArea);
};
export const copyTextToClipboard = (text: string) => {
  if (!navigator.clipboard) {
    fallbackCopyTextToClipboard(text);
    return;
  }
  navigator.clipboard.writeText(text).then(
    function () {
      toast.success(Lang.key('copiedToClipboard'));
    },
    function (err) { }
  );
};



export const hexToRgb = (hex: string) => {
  const bigint = parseInt(hex.substring(1), 16);
  const r = (bigint >> 16) & 255;
  const g = (bigint >> 8) & 255;
  const b = bigint & 255;

  return [r, g, b];
};


export const structureHaveType = (type: TypeABCDEFGHILMPRSTUEnum, structure: StructureType | null): boolean => {

  if (!structure) return false;

  let have = false;

  _.map(structure.items, (field, key) => {
    if (field.type === type) {
      have = true;
    }
  });

  return have;


}



const getAllValues = (obj: any) => {
  let result: any[] = [];

  _.forOwn(obj, (value) => {
    if (_.isPlainObject(value)) {
      result = result.concat(getAllValues(value));
    } else if (_.isArray(value)) {
      value.forEach((item) => {
        if (_.isPlainObject(item)) {
          result = result.concat(getAllValues(item));
        } else {
          result.push(item);
        }
      });
    } else {
      result.push(value);
    }
  });

  return result;
}

export const isFilled = (values: any) => {

  if (!values) return false;

  let allValues = getAllValues(values);


  return allValues.filter((e) => e).length > 0;
}



export const getAnyGeoPointFormData = (
  data: any,
  structure: StructureType
): {
  lat: number;
  lng: number;
} | null => {
  let center: {
    lat: number;
    lng: number;
  } | null = null;

  _.map(structure.items, (val, key) => {
    if (center) return;

    if (val.type == 'geopoint' && data?.[key]?.lat && data?.[key]?.lng) {
      center = {
        lat: data?.[key]?.lat,
        lng: data?.[key]?.lng,
      };
    }
  });

  return center;
};








