package main

import (
	"log"
	"os"
	"os/signal"
	"syscall"
	"time"

	"github.com/shm/schema/services/go/config"
)

func main() {
	log.Println("Go worker service starting...")

	// Загружаем конфигурацию из PHP проекта
	cfg, err := config.Load()
	if err != nil {
		log.Fatalf("Failed to load config: %v", err)
	}

	log.Printf("Config loaded successfully")
	log.Printf("Go Service Port: %d", cfg.GoService.Port)
	log.Printf("Redis Prefix: %s", cfg.GoService.Prefix)
	log.Printf("Redis Host: %s:%d", cfg.Redis.Host, cfg.Redis.Port)

	// Канал для graceful shutdown
	stop := make(chan os.Signal, 1)
	signal.Notify(stop, os.Interrupt, syscall.SIGTERM)

	// Основной цикл обработки задач
	done := make(chan bool)
	go func() {
		for {
			select {
			case <-stop:
				log.Println("Received shutdown signal, stopping...")
				done <- true
				return
			default:
				// Здесь будет ваша логика обработки задач
				// Например, обработка очереди, периодические задачи и т.д.
				// Конфигурация доступна через cfg
				
				// Пример: просто ждем и логируем
				log.Println("Worker is running...")
				time.Sleep(5 * time.Second)
			}
		}
	}()

	// Ожидание завершения
	<-done
	log.Println("Go worker service stopped")
}
