<?php

namespace Shm\ShmAdmin\AdminRPC;

use Shm\Shm;
use Shm\ShmAdmin\AdminPanel;
use Shm\ShmAdmin\Types\BaseStructureType;
use Shm\ShmAuth\Auth;
use Shm\ShmRPC\ShmRPC;
use Shm\ShmUtils\I18n;
use Shm\ShmUtils\Response;

class AdminRPCFilter
{
    public static function rpc()
    {

        return ShmRPC::lazy(function () {

            return [
                'type' => BaseStructureType::get(),
                'args' => [
                    'collection' => Shm::nonNull(Shm::string()),
                ],
                'resolve' => function ($root, $args) {

                    Auth::authenticateOrThrow(...AdminPanel::$authStructures);

                    if (!isset($args['collection'])) {
                        Response::validation(I18n::get('data_not_available_for_view'));
                    }

                    $structure = AdminPanel::fullSchema()->findItemByCollection($args['collection']);

                    return $structure->filterType()->json();
                }
            ];
        });
    }
}
