<?php

namespace Shm\ShmTypes\Classes;

use Shm\ShmTypes\Classes\EventClasses\ShmEventAfterDeletePayload;
use Shm\ShmTypes\Classes\EventClasses\ShmEventAfterInsertPayload;
use Shm\ShmTypes\Classes\EventClasses\ShmEventAfterLoginPayload;
use Shm\ShmTypes\Classes\EventClasses\ShmEventAfterRegisterPayload;
use Shm\ShmTypes\Classes\EventClasses\ShmEventAfterUpdatePayload;
use Shm\ShmTypes\Classes\EventClasses\ShmEventPreDeletePayload;
use Shm\ShmTypes\Classes\EventClasses\ShmEventPreInsertPayload;
use Shm\ShmTypes\Classes\EventClasses\ShmEventPreUpdatePayload;

class ShmEventPayload
{

    // Именованные константы для автодополнения и переиспользования
    public const EVENT_AFTER_REGISTER = 'after_register';
    public const EVENT_AFTER_LOGIN    = 'after_login';

    //Перед добавлением в базу данных
    public const EVENT_PRE_INSERT = 'pre_insert';
    //После добавления в базу данных
    public const EVENT_AFTER_INSERT = 'after_insert';
    //Перед обновлением в базу данных
    public const EVENT_PRE_UPDATE = 'pre_update';
    //После обновления в базу данных
    public const EVENT_AFTER_UPDATE = 'after_update';
    //Перед удалением из базу данных
    public const EVENT_PRE_DELETE = 'pre_delete';
    //После удаления из базу данных
    public const EVENT_AFTER_DELETE = 'after_delete';


    //Перед добавлением в базу через админку
    public const EVENT_PRE_INSERT_ADMIN = 'pre_insert_admin';
    //После добавления в базу через админку
    public const EVENT_AFTER_INSERT_ADMIN = 'after_insert_admin';
    //Перед обновлением в базу через админку
    public const EVENT_PRE_UPDATE_ADMIN = 'pre_update_admin';
    //После обновления в базу через админку
    public const EVENT_AFTER_UPDATE_ADMIN = 'after_update_admin';
    //Перед удалением из базу через админку
    public const EVENT_PRE_DELETE_ADMIN = 'pre_delete_admin';
    //После удаления из базу через админку
    public const EVENT_AFTER_DELETE_ADMIN = 'after_delete_admin';


    /** Белый список событий, доступных в системе */
    public const ALLOWED_EVENTS = [
        self::EVENT_AFTER_REGISTER,
        self::EVENT_AFTER_LOGIN,
        self::EVENT_PRE_INSERT,
        self::EVENT_AFTER_INSERT,
        self::EVENT_PRE_UPDATE,
        self::EVENT_AFTER_UPDATE,
        self::EVENT_PRE_DELETE,
        self::EVENT_AFTER_DELETE,
        self::EVENT_PRE_INSERT_ADMIN,
        self::EVENT_AFTER_INSERT_ADMIN,
        self::EVENT_PRE_UPDATE_ADMIN,
        self::EVENT_AFTER_UPDATE_ADMIN,
        self::EVENT_PRE_DELETE_ADMIN,
        self::EVENT_AFTER_DELETE_ADMIN,
    ];

    public ShmEventPreInsertPayload $preInsertPayload;
    public ShmEventAfterInsertPayload $afterInsertPayload;
    public ShmEventPreUpdatePayload $preUpdatePayload;
    public ShmEventAfterUpdatePayload $afterUpdatePayload;
    public ShmEventPreDeletePayload $preDeletePayload;
    public ShmEventAfterDeletePayload $afterDeletePayload;

    public ShmEventAfterRegisterPayload $afterRegisterPayload;
    public ShmEventAfterLoginPayload $afterLoginPayload;
}