<?php

namespace Shm\ShmUtils;

class I18n
{
    /**
     * @param array<string, string> $replace [placeholder => value], e.g. ['width' => '1920']
     */
    public static function get(string $key, array $replace = []): string
    {
        $text = self::$dictionary[$key] ?? self::$defaultDictionary[$key] ?? $key;
        foreach ($replace as $placeholder => $value) {
            $text = str_replace('{' . $placeholder . '}', (string) $value, $text);
        }
        return $text;
    }

    public static function setDictionary(array $dictionary): void
    {
        self::$dictionary = $dictionary;
    }

    /** @var array<string, string> Overrides for defaultDictionary */
    private static array $dictionary = [];

    /** @var array<string, string> */
    private static array $defaultDictionary = [
        'api_key_name_required' => 'Не указано название ключа',
        'api_key_create_error' => 'Ошибка при создании ключа',
        'video_too_wide' => 'Видео слишком широкое ({width} пикселей). Максимальная ширина - {max} пикселей.',
        'auth_error' => 'Ошибка авторизации',
        'channel_not_found' => 'Канал не найден',
        'not_channel_member' => 'Вы не являетесь участником канала',
        'channel_message_reaction_not_found' => 'Канал, сообщение или реакция не найдены',
        'message_not_found' => 'Сообщение не найдено',
        'channel_or_message_not_found' => 'Канал или сообщение не найдены',
        'wrong_code' => 'Вы указали неверный код.',
        'email_registration_unavailable' => 'Регистрация по Email на текущий момент недоступна.',
        'email_registration_not_available' => 'Регистрация на указанный email недоступна.',
        'email_recovery_not_configured' => 'Email для восстановления пароля не задан. Обратитесь в поддержку.',
        'wrong_password' => 'Пароль указан неверно.',
        'method_required' => 'Method is required.',
        'export_active_wait' => 'У вас уже есть активный экспорт. Подождите, пока он завершится.',
        'export_name_required' => 'Не указано название экспорта',
        'export_data_not_available' => 'Данные недоступны для экспорта',
        'data_not_available_for_view' => 'Данные недоступны для просмотра',
        'document_not_found_or_no_access' => 'Документ не найден или нет доступа',
        'request_execution_error' => 'Ошибка выполнения запроса',
        'method_not_callable' => 'Method is not callable.',
        'action_cannot_execute' => 'Невозможно выполнить действие!',
        'data_not_available' => 'Данные недоступны',
        'action_not_found' => 'Действие не найдено',
        'access_denied' => 'Ошибка доступа',
        'insert_fields_required' => 'Fields required for insert operation',
        'update_record_id_required' => 'Record ID required for update operation',
        'access_denied_edit_record' => 'Ошибка доступа, у вас нет доступа для редактирования этой записи',
        'no_data_to_update' => 'Нет данных для обновления',
        'add_data_error' => 'Ошибка при добавлении данных',
        'payment_error_try_later' => 'Ошибка оплаты. Попробуйте позже',
        'amount_must_be_positive' => 'Сумма должна быть больше нуля',
        'currency_not_supported' => 'Валюта не поддерживается',
        'sort_change_not_available' => 'Изменения сортировки недоступны',
        'api_key_id_required' => 'Не указан ID ключа',
        'api_key_not_found' => 'Ключ не найден или не принадлежит вам',
        'statement_export_active_wait' => 'У вас уже есть активный экспорт ведомости расчётов. Подождите, пока он завершится.',
        'no_data_to_delete' => 'Нет данных для удаления',
        'export_not_found' => 'Экспорт не найден',
        'image_file_required' => 'Поле file обязательно для загрузки файла',
        'auth_phone_not_supported' => 'Авторизация по телефону не поддерживается',
        'auth_social_not_supported' => 'Социальные сети не поддерживаются',
        'fill_required_fields' => 'Заполните все необходимые поля',
        'too_many_attempts' => 'Доступ заблокирован из-за большого количества неудачных попыток. Попробуйте ещё раз через одну минуту.',
        'account_not_found' => 'Ваша учётная запись не найдена.',
        'file_upload_error' => 'Ошибка при загрузке файла',
        'wrong_sms_code' => 'Неверный SMS код',
        'account_not_found_phone' => 'Не найден аккаунт с таким номером телефона.',
        'wrong_call_code' => 'Неверный код',
        'auth_passport_error' => 'Ошибка авторизации',
        'account_not_found_login' => 'Не найден аккаунт с таким email или логином, либо неверный пароль.',
        'file_not_uploaded' => 'Файл не загружен',
    ];
}
